/**
 * TypeScript type definitions
 */

export interface AIProvider {
  id: string;
  name: string;
  requiresApiKey: boolean;
  defaultModel: string;
}

export interface AIModel {
  id: string;
  name: string;
  provider: string;
}

export interface ChatMessage {
  role: 'system' | 'user' | 'assistant';
  content: string;
  timestamp?: number;
}

export interface ChatOptions {
  model?: string;
  temperature?: number;
  maxTokens?: number;
  stream?: boolean;
}

export interface Settings {
  apiKeys: Record<string, string>;
  defaultProvider: string;
  defaultModel: string | null;
  temperature: number;
  maxTokens: number;
}

export interface ProjectFile {
  name: string;
  content: string;
  language: string;
}

export interface Project {
  id: string;
  name: string;
  files: Record<string, string>;
  settings?: any;
  createdAt: string;
  updatedAt: string;
}

export interface APIResponse<T = any> {
  success: boolean;
  data?: T;
  error?: string;
  message?: string;
}
