import React from 'react';
import { useStore } from '../store/useStore';

interface LayoutProps {
  children: React.ReactNode;
}

export const Layout: React.FC<LayoutProps> = ({ children }) => {
  const { currentPage, setCurrentPage } = useStore();

  const menuItems = [
    { id: 'chat' as const, label: 'AI Chat', icon: '💬' },
    { id: 'editor' as const, label: 'Kod Muharrir', icon: '📝' },
    { id: 'preview' as const, label: 'Ko\'rish', icon: '👁️' },
    { id: 'settings' as const, label: 'Sozlamalar', icon: '⚙️' }
  ];

  return (
    <div className="app-layout">
      <header className="app-header">
        <div className="header-content">
          <h1 className="app-title">AI Builder Platform</h1>
          <p className="app-subtitle">AI yordamida web loyihalar yarating</p>
        </div>
      </header>

      <nav className="app-nav">
        {menuItems.map((item) => (
          <button
            key={item.id}
            className={`nav-item ${currentPage === item.id ? 'active' : ''}`}
            onClick={() => setCurrentPage(item.id)}
          >
            <span className="nav-icon">{item.icon}</span>
            <span className="nav-label">{item.label}</span>
          </button>
        ))}
      </nav>

      <main className="app-main">{children}</main>

      <footer className="app-footer">
        <p>AI Builder Platform v1.0.0 | O'zbek tilida yaratilgan</p>
      </footer>
    </div>
  );
};
