import CryptoJS from 'crypto-js';

/**
 * API keylarni shifrlash va deshifrlash
 */

const ENCRYPTION_KEY = process.env.ENCRYPTION_KEY || 'default-key-change-in-production-32';

/**
 * Ma'lumotni shifrlash
 */
export function encrypt(text) {
  if (!text) return '';

  try {
    const encrypted = CryptoJS.AES.encrypt(text, ENCRYPTION_KEY).toString();
    return encrypted;
  } catch (error) {
    console.error('Shifrlash xatosi:', error);
    throw new Error('Shifrlash amalga oshmadi');
  }
}

/**
 * Shifrni ochish
 */
export function decrypt(encryptedText) {
  if (!encryptedText) return '';

  try {
    const bytes = CryptoJS.AES.decrypt(encryptedText, ENCRYPTION_KEY);
    const decrypted = bytes.toString(CryptoJS.enc.Utf8);

    if (!decrypted) {
      throw new Error('Deshifrlash amalga oshmadi');
    }

    return decrypted;
  } catch (error) {
    console.error('Deshifrlash xatosi:', error);
    throw new Error('Deshifrlash amalga oshmadi');
  }
}

/**
 * API key formatini tekshirish
 */
export function validateApiKey(key, provider) {
  if (!key || typeof key !== 'string') {
    return false;
  }

  // Provider bo'yicha basic validatsiya
  switch (provider) {
    case 'openai':
      return key.startsWith('sk-') && key.length > 20;
    case 'anthropic':
      return key.startsWith('sk-ant-') && key.length > 20;
    case 'google':
      return key.length > 20;
    case 'openrouter':
      return key.startsWith('sk-or-') && key.length > 20;
    case 'deepseek':
      return key.length > 20;
    case 'ollama':
      return true; // Ollama key talab qilmaydi
    default:
      return key.length > 10;
  }
}
