import rateLimit from 'express-rate-limit';

/**
 * Rate limiting middleware
 * So'rovlarni cheklash
 */

// Umumiy API rate limiter
export const apiLimiter = rateLimit({
  windowMs: parseInt(process.env.RATE_LIMIT_WINDOW_MS) || 15 * 60 * 1000, // 15 daqiqa
  max: parseInt(process.env.RATE_LIMIT_MAX_REQUESTS) || 100,
  message: {
    success: false,
    error: 'Juda ko\'p so\'rov. Iltimos, keyinroq qayta urinib ko\'ring.'
  },
  standardHeaders: true,
  legacyHeaders: false
});

// AI so'rovlari uchun maxsus limiter (kamroq so'rov)
export const aiLimiter = rateLimit({
  windowMs: 1 * 60 * 1000, // 1 daqiqa
  max: 20,
  message: {
    success: false,
    error: 'AI so\'rovlari cheklandi. 1 daqiqa kutib turing.'
  },
  standardHeaders: true,
  legacyHeaders: false
});

// Export uchun limiter (juda kam so'rov)
export const exportLimiter = rateLimit({
  windowMs: 5 * 60 * 1000, // 5 daqiqa
  max: 5,
  message: {
    success: false,
    error: 'Export cheklandi. 5 daqiqa kutib turing.'
  },
  standardHeaders: true,
  legacyHeaders: false
});
