import { saveChatHistory, getChatHistory } from '../utils/storage.js';

/**
 * Chat tarixi bilan bog'liq API endpointlar
 */

/**
 * Chat tarixini saqlash
 */
export async function saveChatHistoryHandler(req, res) {
  try {
    const { sessionId, messages } = req.body;

    if (!sessionId) {
      return res.status(400).json({
        success: false,
        error: 'Session ID ko\'rsatilmagan'
      });
    }

    if (!messages || !Array.isArray(messages)) {
      return res.status(400).json({
        success: false,
        error: 'Xabarlar massivi noto\'g\'ri formatda'
      });
    }

    const result = saveChatHistory(sessionId, messages);

    if (result.success) {
      res.json({
        success: true,
        message: 'Chat tarixi saqlandi'
      });
    } else {
      res.status(500).json(result);
    }
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
}

/**
 * Chat tarixini olish
 */
export async function getChatHistoryHandler(req, res) {
  try {
    const { sessionId } = req.params;

    if (!sessionId) {
      return res.status(400).json({
        success: false,
        error: 'Session ID ko\'rsatilmagan'
      });
    }

    const messages = getChatHistory(sessionId);

    res.json({
      success: true,
      messages
    });
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
}
