/**
 * BaseAdapter - Barcha AI providerlar uchun asosiy interface
 * Yangi AI qo'shish uchun bu klassdan extend qiling
 */
export class BaseAdapter {
  constructor(apiKey, config = {}) {
    if (!apiKey) {
      throw new Error('API key talab qilinadi');
    }
    this.apiKey = apiKey;
    this.config = config;
  }

  /**
   * Promptni standart formatga keltirish
   */
  sanitizePrompt(prompt) {
    if (!prompt || typeof prompt !== 'string') {
      throw new Error('Prompt noto\'g\'ri formatda');
    }

    // Prompt injection himoya
    const dangerousPatterns = [
      /ignore\s+previous\s+instructions/i,
      /system\s*:/i,
      /<\s*script/i,
      /javascript:/i
    ];

    for (const pattern of dangerousPatterns) {
      if (pattern.test(prompt)) {
        console.warn('Xavfli pattern topildi, tozalanyapti');
        prompt = prompt.replace(pattern, '[xavfli kontent o\'chirildi]');
      }
    }

    return prompt.trim();
  }

  /**
   * API keyni tekshirish
   */
  async testConnection() {
    throw new Error('testConnection() metodi implement qilinishi kerak');
  }

  /**
   * Chat completion - asosiy metod
   */
  async chat(messages, options = {}) {
    throw new Error('chat() metodi implement qilinishi kerak');
  }

  /**
   * Streaming chat
   */
  async chatStream(messages, options = {}, onChunk) {
    throw new Error('chatStream() metodi implement qilinishi kerak');
  }

  /**
   * Mavjud modellar ro'yxati
   */
  async getModels() {
    throw new Error('getModels() metodi implement qilinishi kerak');
  }

  /**
   * Provider nomi
   */
  getProviderName() {
    throw new Error('getProviderName() metodi implement qilinishi kerak');
  }

  /**
   * Xatoni formatlash
   */
  formatError(error) {
    if (error.response) {
      return {
        success: false,
        error: error.response.data?.error?.message || error.message,
        status: error.response.status
      };
    }
    return {
      success: false,
      error: error.message
    };
  }
}
