# AI Builder Platform

AI yordamida web loyihalar yarating. To'liq funksional, ishlab chiqarishga tayyor platforma.

## 🌟 Xususiyatlar

### ✅ AI Chat
- 6 ta AI provider qo'llab-quvvatlash (OpenAI, Anthropic, Google Gemini, OpenRouter, DeepSeek, Ollama)
- Streaming javoblar (jonli yozilish)
- System prompt sozlash
- Temperature va token limit sozlamalari
- Chat tarixi saqlash

### ✅ Kod Muharrir
- Monaco Editor (VS Code kabi)
- Syntax highlighting
- IntelliSense
- Ko'p fayl bilan ishlash
- HTML, CSS, JavaScript qo'llab-quvvatlash

### ✅ Jonli Ko'rish (Preview)
- Brauzer ichida jonli ko'rish
- Console output ko'rsatish
- Xatoliklarni ko'rsatish
- Qayta yuklash

### ✅ Sozlamalar
- API keylarni shifrlangan holda saqlash
- API keylarni test qilish
- Standart AI va model tanlash
- Temperature va token limit sozlash

### ✅ Export
- Loyihani ZIP qilib yuklab olish
- Butun platformani ZIP qilib yuklab olish
- README.md avtomatik yaratish

## 🚀 Ishga Tushirish

### Talablar
- Node.js 18+ yoki 20+
- npm yoki yarn

### 1️⃣ Backend ni ishga tushirish

```bash
cd backend
npm install
npm start
```

Backend http://localhost:5000 da ishga tushadi.

### 2️⃣ Frontend ni ishga tushirish

```bash
cd frontend
npm install
npm run dev
```

Frontend http://localhost:3000 da ishga tushadi.

### 3️⃣ Brauzerda ochish

http://localhost:3000 ga kiring.

## 📁 Loyiha Strukturasi

```
ai-builder-platform/
├── backend/
│   ├── adapters/          # AI provider adapters
│   │   ├── BaseAdapter.js
│   │   ├── OpenAIAdapter.js
│   │   ├── AnthropicAdapter.js
│   │   ├── GoogleAdapter.js
│   │   ├── OpenRouterAdapter.js
│   │   ├── DeepSeekAdapter.js
│   │   └── OllamaAdapter.js
│   ├── controllers/       # API controllers
│   │   ├── aiController.js
│   │   ├── settingsController.js
│   │   ├── projectController.js
│   │   └── chatController.js
│   ├── services/          # Business logic
│   │   └── AIOrchestrator.js
│   ├── utils/             # Utilities
│   │   ├── encryption.js
│   │   └── storage.js
│   ├── middleware/        # Express middleware
│   │   ├── rateLimiter.js
│   │   └── validator.js
│   ├── routes/            # API routes
│   │   └── index.js
│   ├── storage/           # Ma'lumotlar (avtomatik yaratiladi)
│   ├── server.js          # Express server
│   ├── package.json
│   └── .env
│
├── frontend/
│   ├── src/
│   │   ├── components/    # React komponentlar
│   │   │   └── Layout.tsx
│   │   ├── pages/         # Sahifalar
│   │   │   ├── ChatPage.tsx
│   │   │   ├── EditorPage.tsx
│   │   │   ├── PreviewPage.tsx
│   │   │   └── SettingsPage.tsx
│   │   ├── services/      # API xizmatlari
│   │   │   └── api.ts
│   │   ├── store/         # State management (Zustand)
│   │   │   └── useStore.ts
│   │   ├── types/         # TypeScript types
│   │   │   └── index.ts
│   │   ├── App.tsx
│   │   ├── main.tsx
│   │   └── index.css
│   ├── index.html
│   ├── vite.config.ts
│   ├── package.json
│   └── .env
│
└── README.md
```

## ⚙️ Sozlash

### Backend Sozlamalari (.env)

```env
PORT=5000
NODE_ENV=development
ENCRYPTION_KEY=ai-builder-secret-key-change-this-in-production-2024
RATE_LIMIT_WINDOW_MS=900000
RATE_LIMIT_MAX_REQUESTS=100
```

### Frontend Sozlamalari (.env)

```env
VITE_API_URL=http://localhost:5000/api
```

## 🔐 API Keylar

### OpenAI
1. https://platform.openai.com/api-keys ga kiring
2. "Create new secret key" bosing
3. Keygen platformaga kiriting

### Anthropic (Claude)
1. https://console.anthropic.com/settings/keys ga kiring
2. "Create Key" bosing
3. Keygen platformaga kiriting

### Google Gemini
1. https://makersuite.google.com/app/apikey ga kiring
2. "Create API key" bosing
3. Keygen platformaga kiriting

### OpenRouter
1. https://openrouter.ai/keys ga kiring
2. Yangi key yarating
3. Keygen platformaga kiriting

### DeepSeek
1. https://platform.deepseek.com/api_keys ga kiring
2. Yangi key yarating
3. Keygen platformaga kiriting

### Ollama (Local)
1. https://ollama.com/download dan Ollama yuklab oling
2. Ollama ni ishga tushiring
3. Terminal: `ollama run llama2`
4. API key talab qilinmaydi

## 📡 API Endpointlar

### AI Endpointlar
- `GET /api/ai/providers` - Providerlar ro'yxati
- `POST /api/ai/test` - API connection test
- `POST /api/ai/models` - Modellar ro'yxati
- `POST /api/ai/chat` - Chat (oddiy)
- `POST /api/ai/chat/stream` - Chat (streaming)

### Sozlamalar
- `GET /api/settings` - Sozlamalarni olish
- `POST /api/settings` - Sozlamalarni saqlash
- `POST /api/settings/api-key` - API keyni yangilash
- `POST /api/settings/reset` - Standartga qaytarish

### Loyihalar
- `GET /api/projects` - Barcha loyihalar
- `GET /api/projects/:id` - Bitta loyiha
- `POST /api/projects` - Loyihani saqlash
- `DELETE /api/projects/:id` - Loyihani o'chirish
- `GET /api/projects/:id/export` - Loyihani export

### Platform Export
- `GET /api/export/platform` - Platformani export

## 🛡️ Xavfsizlik

- ✅ API keylar AES shifrlangan
- ✅ Rate limiting (so'rovlar cheklash)
- ✅ Input validation
- ✅ Prompt injection himoya
- ✅ JSON bomb himoya
- ✅ CORS sozlangan
- ✅ Helmet middleware

## 🎯 Ishlatish

### 1. AI Chat
1. Sozlamalarga kiring
2. AI provider tanlang va API key kiriting
3. "Test" tugmasini bosing
4. Chat sahifasiga o'ting
5. AI bilan suhbat boshlang

### 2. Kod Yozish
1. "Kod Muharrir" sahifasiga o'ting
2. Fayllarni tahrirlang
3. Yangi fayl yaratish uchun "+" tugmasini bosing

### 3. Ko'rish
1. "Ko'rish" sahifasiga o'ting
2. Loyiha jonli ko'rsatiladi
3. Console output ko'rish uchun "Console" tugmasini bosing

### 4. Export
1. Loyihani saqlang (avtomatik)
2. "Ko'rish" sahifasida "Loyihani Yuklab Olish" bosing
3. ZIP fayl yuklab olinadi

## 🔧 Muammolarni Hal Qilish

### Backend ishlamayapti
```bash
cd backend
npm install
node server.js
```

### Frontend ishlamayapti
```bash
cd frontend
npm install
npm run dev
```

### API key xato
- Sozlamalarda API keyni tekshiring
- "Test" tugmasini bosing
- Provider websitesida keyni yangilang

### Ollama ulanmayapti
```bash
# Ollama ishga tushiring
ollama serve

# Model yuklab oling
ollama pull llama2
```

## 📦 Production Build

### Backend
```bash
cd backend
npm install --production
NODE_ENV=production npm start
```

### Frontend
```bash
cd frontend
npm run build
# dist/ papkasi yaratiladi
```

## 🌐 Deploy

### Backend (Node.js server)
1. Backend fayllarni serverga yuklang
2. `.env` faylni sozlang
3. `npm install` va `npm start`

### Frontend (Static hosting)
1. `npm run build` bajaring
2. `dist/` papkasini hosting serverga yuklang (Netlify, Vercel, etc.)

## 🤝 Hissa Qo'shish

1. Fork qiling
2. Feature branch yarating (`git checkout -b feature/amazing`)
3. Commit qiling (`git commit -m 'Add amazing feature'`)
4. Push qiling (`git push origin feature/amazing`)
5. Pull Request yarating

## 📄 Litsenziya

MIT License - O'zingizga moslang va ishlating!

## 👨‍💻 Muallif

AI Builder Platform - O'zbek tilida yaratilgan

## 🙏 Minnatdorchilik

- Monaco Editor
- React
- Express.js
- OpenAI, Anthropic, Google, va boshqa AI providerlar

---

**Eslatma:** Bu platforma demo emas, real ishlaydigan production-ready dasturdir!
