# O'RNATISH BO'YICHA TO'LIQ YO'RIQNOMA

AI Builder Platform ni o'rnatish va ishga tushirish bo'yicha qadamma-qadam yo'riqnoma.

## 📋 Talablar

- **Node.js**: 18.x yoki 20.x versiyasi
- **npm**: 9.x yoki yuqori
- **Brauzer**: Chrome, Firefox, Safari, Edge (oxirgi versiyalar)

## 🔧 1-QADAM: Node.js O'rnatish

### Windows
1. https://nodejs.org/en ga kiring
2. LTS versiyasini yuklab oling
3. O'rnatuvchini ishga tushiring
4. Terminalda tekshirish: `node --version` va `npm --version`

### macOS
```bash
# Homebrew orqali
brew install node@20
```

### Linux (Ubuntu/Debian)
```bash
curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -
sudo apt-get install -y nodejs
```

## 🚀 2-QADAM: Loyihani Yuklab Olish

Agar ZIP dan ochgan bo'lsangiz, fayllarni katalogga chiqaring.

Yoki Git orqali:
```bash
git clone <repository-url>
cd ai-builder-platform
```

## ⚙️ 3-QADAM: Backend ni Sozlash

```bash
# Backend papkasiga kiring
cd backend

# Paketlarni o'rnatish
npm install

# .env faylni yaratish (.env.example dan nusxa ko'chirish)
# Windows
copy .env.example .env

# Linux/Mac
cp .env.example .env
```

### .env Faylni Tahrirlash

`.env` faylni matn muharririda oching va kerakli qiymatlarni kiriting:

```env
PORT=5000
NODE_ENV=development
ENCRYPTION_KEY=o-zingizning-32-belgili-maxfiy-kalitingiz-shu-yerda
RATE_LIMIT_WINDOW_MS=900000
RATE_LIMIT_MAX_REQUESTS=100
```

**Muhim:** `ENCRYPTION_KEY` ni o'zgartiring! Kamida 32 belgidan iborat bo'lishi kerak.

## 🎨 4-QADAM: Frontend ni Sozlash

```bash
# Frontend papkasiga kiring
cd ../frontend

# Paketlarni o'rnatish
npm install

# .env faylni yaratish
# Windows
copy .env.example .env

# Linux/Mac
cp .env.example .env
```

`.env` faylda API URL ni tekshiring:
```env
VITE_API_URL=http://localhost:5000/api
```

## ▶️ 5-QADAM: Ishga Tushirish

### Backend ni Ishga Tushirish

Yangi terminal oynasida:

```bash
cd backend
npm start
```

Natija:
```
╔════════════════════════════════════════╗
║   AI Builder Platform Backend API      ║
╠════════════════════════════════════════╣
║   Server: http://localhost:5000        ║
║   Environment: development             ║
║   Status: ✓ Ishga tushdi               ║
╚════════════════════════════════════════╝
```

### Frontend ni Ishga Tushirish

Boshqa terminal oynasida:

```bash
cd frontend
npm run dev
```

Natija:
```
  VITE v5.0.8  ready in 500 ms

  ➜  Local:   http://localhost:3000/
  ➜  Network: use --host to expose
  ➜  press h to show help
```

## 🌐 6-QADAM: Brauzerda Ochish

Brauzeringizni oching va quyidagi manzilga kiring:

```
http://localhost:3000
```

Platform ochilishi kerak!

## 🔑 7-QADAM: API Keylarni Sozlash

1. Platformada "Sozlamalar" sahifasiga o'ting
2. Kerakli AI provider uchun API key kiriting
3. "Test" tugmasini bosing
4. Agar ulanish muvaffaqiyatli bo'lsa, "Saqlash" tugmasini bosing

### API Key Olish

#### OpenAI
- https://platform.openai.com/api-keys
- "Create new secret key" bosing
- Keyni nusxa ko'chiring

#### Anthropic (Claude)
- https://console.anthropic.com/settings/keys
- "Create Key" bosing
- Keyni nusxa ko'chiring

#### Google Gemini
- https://makersuite.google.com/app/apikey
- "Create API key" bosing
- Keyni nusxa ko'chiring

#### OpenRouter
- https://openrouter.ai/keys
- Account yaratib, key oling

#### DeepSeek
- https://platform.deepseek.com/api_keys
- Account yaratib, key oling

#### Ollama (Local, API key kerak emas)
```bash
# Ollama o'rnatish
# https://ollama.com/download

# Model yuklab olish
ollama pull llama2

# Ishga tushirish
ollama serve
```

## ✅ 8-QADAM: Test Qilish

### AI Chat Test
1. "AI Chat" sahifasiga o'ting
2. Provider va Model tanlang
3. Xabar yozing va "Yuborish" tugmasini bosing
4. AI javob berishi kerak

### Code Editor Test
1. "Kod Muharrir" sahifasiga o'ting
2. `index.html` faylini tahrirlang
3. Kod yozing

### Preview Test
1. "Ko'rish" sahifasiga o'ting
2. Kod jonli ko'rsatilishi kerak
3. Console tugmasini bosing
4. Console output ko'rinishi kerak

## 🐛 Muammolarni Hal Qilish

### Backend ishlamayapti

**Xato:** `Error: Cannot find module`
```bash
cd backend
rm -rf node_modules package-lock.json
npm install
```

**Xato:** `Port 5000 already in use`
```bash
# .env faylda PORTni o'zgartiring
PORT=5001
```

### Frontend ishlamayapti

**Xato:** `Module not found`
```bash
cd frontend
rm -rf node_modules package-lock.json
npm install
```

**Xato:** `API connection failed`
- Backend ishga tushganini tekshiring
- `.env` faylda `VITE_API_URL` to'g'ri ekanini tekshiring

### API Key xato

**Xato:** `Invalid API key`
- API keyni qayta tekshiring
- Probel yoki qo'shimcha belgilar yo'qligini tekshiring
- Provider websitesida keyni yangilang

### Ollama ulanmayapti

```bash
# Ollama ishga tushiring
ollama serve

# Modelni tekshiring
ollama list

# Model yuklab oling
ollama pull llama2
```

## 🔄 Yangilash

```bash
# Backend
cd backend
npm update

# Frontend
cd frontend
npm update
```

## 📦 Production Build

### Backend
```bash
cd backend
npm install --production
NODE_ENV=production npm start
```

### Frontend
```bash
cd frontend
npm run build
# dist/ papkasi yaratiladi
```

## 🐳 Docker bilan Ishga Tushirish

```bash
# Docker Compose bilan
docker-compose up -d

# Loglarni ko'rish
docker-compose logs -f

# To'xtatish
docker-compose down
```

## 📞 Yordam

Agar muammo yechilmasa:

1. Terminal outputni diqqat bilan o'qing
2. Xato xabarlarini nusxa ko'chiring
3. Node.js va npm versiyalarini tekshiring:
   ```bash
   node --version
   npm --version
   ```

## ✅ Tayyor!

Platform muvaffaqiyatli ishga tushdi. Endi AI yordamida loyihalar yaratishingiz mumkin!

---

**Keyingi qadam:** README.md faylini o'qing va platformaning barcha imkoniyatlari bilan tanishing.
